/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldPresetScreens {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ForgeWorldPreset, WorldPreset> GENERATORS = Maps.newHashMap();
    private static final Map<ForgeWorldPreset, WorldPreset.PresetEditor> GENERATOR_SCREEN_FACTORIES = Maps.newHashMap();

    public static synchronized void registerPresetEditor(ForgeWorldPreset type, WorldPreset.PresetEditor factory) {
        if (GENERATOR_SCREEN_FACTORIES.containsKey(type)) {
            throw new IllegalStateException("Factory has already been registered for: " + type);
        }
        GENERATOR_SCREEN_FACTORIES.put(type, factory);
    }

    static WorldPreset getDefaultPreset() {
        ForgeWorldPreset def = ForgeWorldPreset.getDefaultWorldPreset();
        if (def == null) {
            return WorldPreset.f_101506_;
        }
        WorldPreset gen = GENERATORS.get(def);
        if (gen == null) {
            LOGGER.error("The default world type '{}' has not been added to the GUI. Was it registered too late?", (Object)def.getRegistryName());
            return WorldPreset.f_101506_;
        }
        return gen;
    }

    static WorldPreset.PresetEditor getPresetEditor(Optional<WorldPreset> generator, @Nullable WorldPreset.PresetEditor biomegeneratortypescreens$ifactory) {
        return generator.filter(gen -> gen instanceof GeneratorPreset).map(type -> GENERATOR_SCREEN_FACTORIES.get(((GeneratorPreset)((Object)type)).getWorldPreset())).orElse(biomegeneratortypescreens$ifactory);
    }

    static void registerPresets() {
        ForgeRegistries.WORLD_TYPES.get().forEach(wt -> {
            GeneratorPreset gen = new GeneratorPreset((ForgeWorldPreset)wt);
            GENERATORS.put((ForgeWorldPreset)wt, gen);
            WorldPreset.registerGenerator((WorldPreset)gen);
        });
    }

    private static class GeneratorPreset
    extends WorldPreset {
        private final ForgeWorldPreset worldPreset;

        public GeneratorPreset(ForgeWorldPreset wt) {
            super(wt.getDisplayName());
            this.worldPreset = wt;
        }

        public ForgeWorldPreset getWorldPreset() {
            return this.worldPreset;
        }

        @Nonnull
        public WorldGenSettings m_205485_(@Nonnull RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest) {
            return this.worldPreset.createSettings(dynamicRegistries, seed, generateStructures, bonusChest, "");
        }

        protected ChunkGenerator m_183349_(RegistryAccess p_194083_, long p_194084_) {
            return this.worldPreset.createChunkGenerator(p_194083_, p_194084_, "");
        }
    }
}

